/** !------------------------------------------------------------------------->
*
*  @file PduR_Cfg_generated.h
*
*  @creationDate 21 February 2025 14:00:51
*
*  @brief Generated PduR configuration header file.
*
*  @author
*
*  @description
*
*  @copyright
*    Copyright 2025, dSPACE GmbH. All rights reserved.
*
*!-------------------------------------------------------------------------->*/
#ifndef _PDUR_CFG_GENERATED_H_
#define _PDUR_CFG_GENERATED_H_

/*------------------------------------------------------------------------------------------------*\
  DEFINES
\*------------------------------------------------------------------------------------------------*/

/* Definition of all supported operation modes. */
#define PDUR_GATEWAY_OPERATION      STD_OFF
#define PDUR_COM_SUPPORT            STD_ON
#define PDUR_IPDUM_SUPPORT          STD_OFF
#define PDUR_SECOC_SUPPORT          STD_OFF
#define PDUR_J1939TP_SUPPORT        STD_OFF
#define PDUR_SD_SUPPORT             STD_OFF
#define PDUR_MULTICAST_TOIF_SUPPORT STD_OFF
#define PDUR_MULTICAST_TOTP_SUPPORT STD_OFF
#define PDUR_CANNM_SUPPORT          STD_OFF
#define PDUR_CANIF_SUPPORT          STD_ON
#define PDUR_LINIF_SUPPORT          STD_OFF
#define PDUR_SOAD_SUPPORT           STD_OFF
#define PDUR_DEV_ERROR_DETECT       STD_OFF
#define PDUR_ZERO_COST_OPERATION    STD_OFF

#define PDUR_MODULE_INIT_STRUCTURE \
{ \
    { \
        CanIf_Transmit, \
        0, \
        0, \
        0, \
        0, \
        0, \
        0, \
        0, \
        0 \
    } ,  \
    { \
        0, \
        Com_TriggerTransmit, \
        0, \
        Com_RxIndication, \
        0, \
        0, \
        0, \
        0, \
        0 \
    }  \
}

#define PDUR_TARGET_MODULE_CANIF_10560_10897 0
#define PDUR_TARGET_MODULE_COM_10560_10897 1
#define PDUR_TARGET_MODULE_NONE 255

#define PDUR_TX_Commands_10560_10897 ((PduIdType) 0)
#define PDUR_TX_HeatTransfer_10560_10897 ((PduIdType) 1)
#define PDUR_TX_Traction_10560_10897 ((PduIdType) 2)

#define PDUR_NUM_TX_PATHS 3


#define PDUR_TX_PATHS  \
{ \
    { \
        { \
            PDUR_TARGET_MODULE_COM_10560_10897, \
            Com_TX_Commands_10842_10560_10897 \
        }, \
        1, \
        0, \
    }  ,  \
    { \
        { \
            PDUR_TARGET_MODULE_COM_10560_10897, \
            Com_TX_HeatTransfer_10841_10560_10897 \
        }, \
        1, \
        1, \
    }  ,  \
    { \
        { \
            PDUR_TARGET_MODULE_COM_10560_10897, \
            Com_TX_Traction_10840_10560_10897 \
        }, \
        1, \
        2, \
    }  \
}

#define PDUR_TX_ENDPOINTS \
{ \
    { \
        PDUR_TARGET_MODULE_CANIF_10560_10897, \
        CanIf_ThermalCAN_Commands_FrameTrig \
    }  ,  \
    { \
        PDUR_TARGET_MODULE_CANIF_10560_10897, \
        CanIf_ThermalCAN_HeatTransfer_FrameTrig \
    }  ,  \
    { \
        PDUR_TARGET_MODULE_CANIF_10560_10897, \
        CanIf_ThermalCAN_Traction_FrameTrig \
    }  \
}



/* Mapping of Interface RX_INDICATION PDU IDs to RX_INDICATION table entries */
#define PDUR_RX_Compressor_10560_10897_CanIf_Com ((PduIdType) 0)
#define PDUR_RX_TempBatt_10560_10897_CanIf_Com ((PduIdType) 1)
#define PDUR_RX_Temperatures_10560_10897_CanIf_Com ((PduIdType) 2)
#define PDUR_RX_Conditions_10560_10897_CanIf_Com ((PduIdType) 3)
#ifndef PDUR_RX_PDUID_NONE
#define PDUR_RX_PDUID_NONE ((PduIdType) -1)
#endif
#define PDUR_NUM_RX_PATHS 4

/* Rx routing table definition. */
#define PDUR_RX_PATHS  \
{ \
    { \
        { \
            PDUR_TARGET_MODULE_COM_10560_10897,\
            Com_RX_Compressor_10843_10560_10897 \
        } \
    }  ,  \
    { \
        { \
            PDUR_TARGET_MODULE_COM_10560_10897,\
            Com_RX_TempBatt_10839_10560_10897 \
        } \
    }  ,  \
    { \
        { \
            PDUR_TARGET_MODULE_COM_10560_10897,\
            Com_RX_Temperatures_10838_10560_10897 \
        } \
    }  ,  \
    { \
        { \
            PDUR_TARGET_MODULE_COM_10560_10897,\
            Com_RX_Conditions_10837_10560_10897 \
        } \
    }  \
}
#endif /* _PDUR_CFG_GENERATED_H_ */

